﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.ComponentModel;
using System.Web.Mvc;
using System.ComponentModel.DataAnnotations;

namespace r12.Models
{
    public class Person
    {
        [HiddenInput(DisplayValue = false)] // Nie chcemy, aby użytkownik widział tej właściwości
        public int PersonId { get; set; }

        // [DisplayName] określa przyjazną dla użytkownika nazwę właściwości 
        [DisplayName("Imię")]
        public string FirstName { get; set; }
        [DisplayName("Nazwisko")]
        public string LastName { get; set; }

        [DataType(DataType.Date)] // Pokazanie tylko daty, bez czasu
        [DisplayName("Urodzony")]
        public DateTime BirthDate { get; set; }

        public Address HomeAddress { get; set; }

        [DisplayName("Może się zalogować?")]
        public bool IsApproved { get; set; }
    }


}